package gov.va.genisis2Test.daoImp;

import java.util.List;

import org.junit.Assert;
import org.junit.Test;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate5.HibernateTemplate;

import gov.va.genisis2.dao.impl.StudyApprovalDao;
import gov.va.genisis2.model.StudyApproval;
import gov.va.genisis2Test.abstractClass.AbstractMockMvcTests;
import gov.va.genisis2Test.util.Helper;

/**
 * The Class StudyApprovalDaoTest.
 *
 * @author1 Janet Lopez
 * 
 *          The Class StudyApprovalDaoTest.
 * 
 *          Description: In this StudyApprovalDaoTest Class which extends the
 *          abstract class, AbstractMockMvcTests, junit tests are defined.
 */

public class StudyApprovalDaoTest extends AbstractMockMvcTests {
	
	/** The logger. */
	private final org.slf4j.Logger logger = LoggerFactory.getLogger(StudyApprovalDaoTest.class);

	/**
	 * To test hibernate template.
	 */
	@Test
	public void TestGetTemplate() {
		// testing for Hibernate Template
		logger.info("**********Junit Test Get Template**********");

		StudyApprovalDao studyApprovalDao = new StudyApprovalDao();
		HibernateTemplate hibernateTemplate = studyApprovalDao.getHibernateTemplate();
		// for coverage
		Assert.assertNull(hibernateTemplate);
		studyApprovalDao.setHibernateTemplate(getMockHibernateTemplate());
		hibernateTemplate = studyApprovalDao.getHibernateTemplate();
		Assert.assertNotNull(hibernateTemplate);

	}

	
	/**
	 * Test create study approval null.
	 */
	@Test
	public void TestCreateStudyApproval_null() {
		// testing when StudyApproval is null
		logger.info("**********Junit Test Create Study Approval Null**********");

		StudyApproval studyApproval = new StudyApproval();
		getMockHibernateTemplate().save(studyApproval);
		int id = getMockStudyApprovalDao().createStudyApproval(studyApproval);

	}

	/**
	 * Test create study approval not null.
	 */
	@Test
	public void TestCreateStudyApproval_notNull() {
		// testing when StudyApproval are not null
		logger.info("**********Junit Test Create Study Approval Not Null**********");

		StudyApproval studyApproval = Helper.getStudyApproval();

		getMockHibernateTemplate().save(studyApproval);

		int id = getMockStudyApprovalDao().createStudyApproval(studyApproval);

	}

	/**
	 * Test get study approval by id.
	 */
	@Test
	public void TestGetStudyApprovalById() {

		logger.info("**********Junit Test Get Study Approval By Id**********");

		StudyApproval studyApproval = Helper.getStudyApproval();

		getMockHibernateTemplate().save(studyApproval);

		StudyApproval studyApproval1 = getMockStudyApprovalDao().getStudyApprovalsByID(1);

	}

	/**
	 * Test get study approval by UID.
	 */
	@Test
	public void TestGetStudyApprovalByUID() {

		logger.info("**********Junit Test Study Approval By UID**********");

		StudyApproval studyApproval = Helper.getStudyApproval();

		List<StudyApproval> studyApprovals = getMockStudyApprovalDao()
				.getStudyApprovalsByUID("approvalIdObtainedTestOne");
	}

	/**
	 * Test update study approval.
	 */
	@Test
	public void TestUpdateStudyApproval() {

		logger.info("**********Junit Test Update Study Approval**********");

		StudyApproval studyApproval = new StudyApproval();
		getMockHibernateTemplate().save(studyApproval);
		studyApproval.setDescription("modified description");
		int id1 = getMockStudyApprovalDao().updateStudyApproval(studyApproval);
	}
}
